from core.db.sql import get_app_a_connection
# from core.utils.php_password_hash import php_password_hash
import bcrypt

class ChitraplayAdapter:
    
    def _derive_password(self, raw_password):
        password_bytes = raw_password.encode('utf-8')
        hashed = bcrypt.hashpw(password_bytes, bcrypt.gensalt(rounds=10))
        return hashed.decode('utf-8')
       
        
    def provision_user(self, user):
        conn = get_app_a_connection()

        print(user)
        try:
            with conn.cursor() as cursor:
                cursor.execute(
                    "SELECT id FROM users WHERE email=%s",
                    (user["primary_email"],)
                )
                chitraplay_user = cursor.fetchone()
                print(chitraplay_user)
                if chitraplay_user:
                     cursor.execute(
                        """
                        UPDATE users
                        SET password = %s, active = 1
                        WHERE email = %s
                        """,
                        (
                            user["chitraplay_password"],
                            user["primary_email"],
                        )
                    )
                else:
                    cursor.execute(
                        """
                        INSERT INTO users (username,email, password, active)
                        VALUES (%s ,%s, %s, %s)
                        """,
                        (
                            user["first_name"],
                            user["primary_email"],
                            user["chitraplay_password"],
                            1
                            
                        )
                    )
            conn.commit()

        except Exception:
            conn.rollback()
            raise

        finally:
            conn.close()
            
    def deactivate_user(self, user):
        conn = get_app_a_connection()
        with conn.cursor() as cursor:
            affected = cursor.execute(
                """
                UPDATE users
                SET active = 0
                WHERE email = %s
                """,
                (user["primary_email"],)
            )
        conn.commit()
        conn.close()


    def update_password(self, user, app_password):
        conn = get_app_a_connection()
        hashed = self._derive_password(app_password)
        try:
            with conn.cursor() as cursor:
                # Check if user exists
                cursor.execute(
                    "SELECT id FROM users WHERE email=%s",
                    (user["primary_email"],)
                )
                existing_user = cursor.fetchone()

                if not existing_user:
                    raise Exception("User not found in Chitraplay")

                # Update password
                cursor.execute(
                    """
                    UPDATE users
                    SET password = %s
                    WHERE email = %s
                    """,
                    (
                        hashed,
                        user["primary_email"],
                    )
                )

            conn.commit()

        except Exception:
            conn.rollback()
            raise

        finally:
            conn.close()