from core.db.sql import get_app_kujanam_connection
import bcrypt


class KujanamAdapter:

    def _derive_password(self, raw_password):
        password_bytes = raw_password.encode("utf-8")
        hashed = bcrypt.hashpw(password_bytes, bcrypt.gensalt(rounds=12))
        return hashed.decode("utf-8")

    def provision_user(self, user):
        conn = get_app_kujanam_connection()

        try:
            with conn.cursor() as cursor:
                cursor.execute(
                    "SELECT id FROM users WHERE email=%s",
                    (user["primary_email"],)
                )
                existing_user = cursor.fetchone()

                if existing_user:
                    cursor.execute(
                        """
                        UPDATE users
                        SET 
                            password = %s,
                            status = 'active',
                            verified = 1,
                            verified_at = NOW(),
                            email_verified_at = NOW()
                        WHERE email = %s
                        """,
                        (
                            user["kujanam_password"],
                            user["primary_email"],
                        )
                    )
                else:
                    cursor.execute(
                        """
                        INSERT INTO users (
                            username,
                            first_name,
                            email,
                            password,
                            status,
                            verified,
                            tips,
                            verified_at,
                            email_verified_at
                        )
                        VALUES (%s, %s, %s, %s, %s, %s, %s, NOW(), NOW())
                        """,
                        (
                            user["primary_email"],   # username
                            user["first_name"],      # first_name
                            user["primary_email"],   # email
                            user["kujanam_password"],# password
                            'active',                # status
                            1,                       # verified
                            "[]",                    # tips ✅
                        )
                    )



            conn.commit()

        except Exception:
            conn.rollback()
            raise

        finally:
            conn.close()

    def deactivate_user(self, user):
        conn = get_app_kujanam_connection()

        try:
            with conn.cursor() as cursor:
                cursor.execute(
                    """
                    UPDATE users
                    SET status = 0
                    WHERE email = %s
                    """,
                    (user["primary_email"],)
                )
            conn.commit()

        finally:
            conn.close()

    def update_password(self, user, app_password):
        conn = get_app_kujanam_connection()
        hashed = self._derive_password(app_password)

        try:
            with conn.cursor() as cursor:
                cursor.execute(
                    "SELECT id FROM users WHERE email=%s",
                    (user["primary_email"],)
                )
                existing_user = cursor.fetchone()

                if not existing_user:
                    raise Exception("User not found in Kujanam")

                cursor.execute(
                    """
                    UPDATE users
                    SET password = %s
                    WHERE email = %s
                    """,
                    (
                        hashed,
                        user["primary_email"],
                    )
                )

            conn.commit()

        except Exception:
            conn.rollback()
            raise

        finally:
            conn.close()
