from django.utils.module_loading import import_string
from .app_registry import APPS

def deactivate_user_from_app(app_id, user):
    if app_id not in APPS:
        raise Exception("Unknown app")

    adapter_path = APPS[app_id]["adapter"]
    adapter_class = import_string(adapter_path)

    adapter = adapter_class()
    adapter.deactivate_user(user)



def update_password_all_apps(user, app_password):
    results = {}

    for app_id in user["connected_apps"]:
        if app_id not in APPS:
            results[app_id] = {
                "success": False,
                "error": "Unknown app"
            }
            continue

        adapter_path = APPS[app_id]["adapter"]
        adapter_class = import_string(adapter_path)
        adapter = adapter_class()

        if not hasattr(adapter, "update_password"):
            results[app_id] = {
                "success": False,
                "error": "Password update not supported"
            }
            continue

        try:
            adapter.update_password(user, app_password)
            results[app_id] = {"success": True}
        except Exception as e:
            results[app_id] = {
                "success": False,
                "error": str(e)
            }

    return results


# def update_user_password_in_app(app_id, user, app_password):
#     if app_id not in APPS:
#         raise Exception("Unknown app")

#     adapter_path = APPS[app_id]["adapter"]
#     adapter_class = import_string(adapter_path)

#     adapter = adapter_class()

#     # if not hasattr(adapter, "update_password"):
#     #     raise Exception("Password update not supported for this app")

#     adapter.update_password(user, app_password)
