from django.utils.module_loading import import_string
from .app_registry import APPS

def provision_user(app_id, user):
    if app_id not in APPS:
        raise Exception("Unknown app")

    adapter_path = APPS[app_id]["adapter"]
    adapter_class = import_string(adapter_path)

    adapter = adapter_class()
    adapter.provision_user(user)
