from datetime import datetime

def validate_dob(dob_str):
    try:
        # Parse the date string
        dob = datetime.strptime(dob_str, "%Y-%m-%d").date()
        # Optional: Check if DOB is not in the future
        if dob > datetime.today().date():
            return False, "DOB cannot be in the future"
        return True, dob
    except ValueError:
        return False, "Invalid date format. Use YYYY-MM-DD"

# # Example usage
# is_valid, result = validate_dob("2002-08-10")
# if is_valid:
#     # print("Valid DOB:", result)
# else:
#     # print("Error:", result)
