from django.shortcuts import render


from rest_framework.decorators import api_view
from rest_framework.response import Response
from rest_framework import status
from apps.auth.decorators import jwt_required
from .models.user import update_user, find_user_by_email, find_user_by_phone,find_user_by_identifier
from .utils.validate_dob import validate_dob
from .models.user import find_user_by_identifier_and_dob
from apps.auth.decorators import jwt_required
from .models.user import find_user_by_id, add_connected_app, remove_connected_app
from apps.accounts.services.provisioner import provision_user
from apps.accounts.services.deprovisioner import deactivate_user_from_app, update_password_all_apps
# from .utils.apps_data import apps_data
from core.db.mongo import apps_col


@api_view(["PATCH"])
@jwt_required
def update_profile(request):
    raw_data = request.data
    user_id = request.user_id
    
    data = {
        k: v for k, v in raw_data.items()
        if v is not None
        and not (isinstance(v, str) and v.strip() == "")
        and not (isinstance(v, (list, dict)) and len(v) == 0)
    }
      
    print("data")
    print(data)
    # 🔒 Prevent password update here
    if "password" in data:
        return Response(
            {"error": "Password cannot be updated here"},
            status=status.HTTP_400_BAD_REQUEST
        )

    # 🔒 Email uniqueness check
    if "primary_email" in data:
        existing = find_user_by_email(data["primary_email"])
        if existing and str(existing["_id"]) != user_id:
            return Response(
                {"error": "Email already in use"},
                status=status.HTTP_400_BAD_REQUEST
            )

    # 🔒 Phone uniqueness check
    if "phone_number" in data:
        existing = find_user_by_phone(data["phone_number"])
        if existing and str(existing["_id"]) != user_id:
            return Response(
                {"error": "Phone number already in use"},
                status=status.HTTP_400_BAD_REQUEST
            )
    if "dob" in data:
        is_valid, result = validate_dob(data["dob"])
        if not is_valid:
                return Response(
            {"error": "Invalid Date of birth"},
            status=status.HTTP_400_BAD_REQUEST
        )
                
    updated = update_user(user_id, data)

    if not updated:
        return Response(
            {"error": "No valid fields to update"},
            status=status.HTTP_400_BAD_REQUEST
        )

    return Response(
        {"message": "Profile updated successfully"},
        status=status.HTTP_200_OK
    )



def mask_email(email):
    name, domain = email.split("@")
    return name[:2] + "***@" + domain


def mask_phone(phone):
    return phone[:2] + "******" + phone[-2:]


@api_view(["POST"])
def find_account(request):
    identifier = request.data.get("identifier")
    dob = request.data.get("dob")  # YYYY-MM-DD

    if not identifier or not dob:
        return Response(
            {"error": "Identifier and DOB are required"},
            status=status.HTTP_400_BAD_REQUEST
        )

    user = find_user_by_identifier_and_dob(identifier, dob)

    # ❌ Always return same message on failure
    if not user:
        return Response(
            {"error": "No matching account found"},
            status=status.HTTP_404_NOT_FOUND
        )

    # ✅ Minimal safe response
    response_data = {
        "message": "Account found",
        "account": {
            "id": str(user["_id"]),
            "primary_email": mask_email(user["primary_email"]),
            "phone_number": mask_phone(user["phone_number"]),
            "is_verified": user.get("is_verified", False)
        }
    }

    return Response(response_data, status=status.HTTP_200_OK)




@api_view(["POST"])
@jwt_required
def connect_app(request, app_id):
    user = find_user_by_id(request.user_id)

    if not user:
        return Response({"error": "User not found"}, status=404)

    if app_id in user.get("connected_apps", []):
        return Response({"message": "Already connected"}, status=200)

    try:
        provision_user(app_id, user)
    except Exception as e:
        return Response({"error": str(e)}, status=400)

    add_connected_app(request.user_id, app_id)

    return Response({"message": f"{app_id} connected successfully"}, status=200)




@api_view(["POST"])
@jwt_required
def disconnect_app(request, app_id):
    user = find_user_by_id(request.user_id)

    if not user:
        return Response({"error": "User not found"}, status=404)

    if app_id not in user.get("connected_apps", []):
        return Response({"message": "App already disconnected"}, status=200)

    try:
        deactivate_user_from_app(app_id, user)
    except Exception as e:
        return Response({"error": str(e)}, status=400)

    remove_connected_app(request.user_id, app_id)

    return Response(
        {"message": f"{app_id} disconnected successfully",}, status=200
    )



# @jwt_required
@api_view(["POST"])
def update_app_password(request,app_password):
    user = find_user_by_id(request.user_id)

    if not user:
        return Response({"error": "User not found"}, status=404)

    if not user.get("connected_apps", []):
        return Response({"message": "No app connected disconnected"}, status=200)

    try:
        update_password_all_apps(user, app_password)
    except Exception as e:
        return Response({"error": str(e)}, status=400)

    # remove_connected_app(request.user_id, app_id)

    return Response(
        {"message": f"Password Updated successfully",}, status=200
    )



from .utils.apps_data import apps_data
@jwt_required
@api_view(["GET"])
def available_apps(request):
    # apps_data = []
    # cursor = apps_col.find(
    #     {"enabled": True},
    #     {
    #         "_id": 0,
    #         "client_secret": 0,
    #         "client_id": 0,
    #         "callback_url": 0,
    #         "redirect_uri": 0,
    #         "created_at" :0
    #     }
    # )

    # for app in cursor:
    #     # print(app)
    #     apps_data.append({
    #     "id": app["system_app_id"],
    #     "name": app["display_name"],
    #     "icon": app.get("icon", {}).get("value"),
    #     "description": app.get("description", "")
    #     })
    
        
    return Response(apps_data, status=status.HTTP_200_OK)
    