from functools import wraps
from rest_framework.response import Response
from rest_framework import status
from .utils.jwt_service import verify_access_token



def jwt_required(view_func):
    @wraps(view_func)
    def wrapper(request, *args, **kwargs):
        # token = request.COOKIES.get("access_token")
        token = None

        auth = request.headers.get("Authorization")
        if auth and auth.startswith("Bearer "):
            token = auth.split(" ", 1)[1]
        
        if not token:
            token = request.COOKIES.get("access_token")
        
        if not token:
            return Response({"error": "Unauthorized"}, status=401)

        payload = verify_access_token(token)
        # print(payload)
        if not payload:
            return Response({"error": "Invalid token"}, status=401)

        request.user_id = payload["sub"]
        return view_func(request, *args, **kwargs)

    return wrapper



