# sessions.py
import uuid, datetime
from core.db.mongo import browser_sessions

def get_or_create_browser_session(request):
    bsid = request.COOKIES.get("browser_session_id")

    if bsid:
        session = browser_sessions.find_one({"_id": bsid})
        if session:
            return session

    bsid = str(uuid.uuid4())
    browser_sessions.insert_one({
        "_id": bsid,
        "active_user_id": None,
        "user_agent": request.META.get("HTTP_USER_AGENT"),
        "ip_address": request.META.get("REMOTE_ADDR"),
        "created_at": datetime.datetime.utcnow(),
        "last_used_at": datetime.datetime.utcnow()
    })
    return browser_sessions.find_one({"_id": bsid})
