from django.urls import path
from .views import delete_account_from_device, test_api, register_user, login_user, me, send_otp, verify_otp,  logout_current_device,logout_all_devices,logout_specific_device, refresh_token, send_recovery_email_otp, verify_recovery_otp, send_forgot_password_otp, verify_forgot_password_otp, reset_password, find_account, verify_find_account_otp,try_another_way, upload_profile_picture,remove_profile_picture, get_logged_in_devices, list_logged_in_accounts, switch_account, delete_account_from_device, logout_account
urlpatterns = [
    path("test/", test_api),
    path("register/", register_user),
    path("login/", login_user),
    path("me/", me),
    path("otp/send/", send_otp),
    path("otp/verify/", verify_otp),
    path("logout/", logout_current_device),
    path("logout-all/", logout_all_devices),
    path("logout-device/", logout_specific_device),
    path("logout-account/", logout_account),
    path("refresh/", refresh_token),
    
    
    # -------------------------
    # OTP – RECOVERY
    # -------------------------
    path(
        "otp/recovery/identifier/send/",
        send_recovery_email_otp,
        name="send-recovery-email-otp",
    ),
    # path(
    #     "otp/recovery/phone/send/",
    #     send_recovery_phone_otp,
    #     name="send-recovery-phone-otp",
    # ),
    
    path(
        "recovery/otp/verify/",
        verify_recovery_otp,
        name="verify-recovery-otp",
    ),
    
    
        # =========================
    # 🔐 FORGOT PASSWORD
    # =========================
    path("password/forgot/send-otp/", send_forgot_password_otp, name="send_forgot_password_otp"),
    path("password/forgot/verify-otp/", verify_forgot_password_otp, name="verify_forgot_password_otp"),
    path("password/reset/", reset_password, name="reset_password"),
    path("password/reset/try-another-way/", try_another_way, name="try_another_way"),
    
    
    
    
    path("find-account/", find_account, name="find_account"),
    path("find-account/verify-otp/", verify_find_account_otp, name="verify_find_account_otp"),
    
    
    
    path("profile/upload-picture/", upload_profile_picture, name="upload_profile_picture"),
    path("profile/remove-picture/", remove_profile_picture, name="remove_profile_picture"),
    
    
     path("logged-in-devices/", get_logged_in_devices, name="get_logged_in_devices"),
    
    
    # 👤 Account Management
    path("accounts/", list_logged_in_accounts, name="list-accounts"),
    path("switch-account/", switch_account, name="switch-account"),
    path("account/delete/", delete_account_from_device),

]
