# auth/cookies.py
COOKIE_KWARGS = dict(
    httponly=True,
    secure=True,  # set False for localhost
    samesite="None",
    # domain=".yourdomain.com",  # None for localhost
    path="/",
)

def set_auth_cookies(response, access_token=None, refresh_token=None):
    if access_token is not None:
        response.set_cookie("access_token", access_token, **COOKIE_KWARGS)
    if refresh_token is not None:
        response.set_cookie("refresh_token", refresh_token, **COOKIE_KWARGS)
