from django.core.mail import EmailMultiAlternatives
from django.conf import settings

from .email_template import get_otp_email_template, get_device_login_template

from django.core.mail import EmailMultiAlternatives
# from django.utils import timezone
from datetime import datetime, timezone, timedelta
import os
from core.utils.decorators import run_in_thread
from core.utils.helpers import env_bool

def send_otp_email(
    to_email: str,
    otp: str,
    username : str,
    sender_email: str,
    sender_name: str,
    purpose: str = "Verification"
):
    """
    Reusable helper to send OTP via email
    """

    subject = f"{purpose} OTP"

    from_email = f"{sender_name} <{sender_email}>"

    text_content = f"""
    Your OTP for {purpose} is: {otp}

    This OTP is valid for a limited time.
    Do not share this OTP with anyone.
    """

    print(text_content)
    
    if not env_bool("ENABLE_SENDING_EMAILS"):
        return True
    
    html_content = get_otp_email_template(username, otp)
    try:
        email = EmailMultiAlternatives(
            subject=subject,
            body=text_content,
            from_email=from_email,
            to=[to_email],
        )
        email.attach_alternative(html_content, "text/html")
        email.send()
        return True

    except Exception as e:
        print("Email send failed:", str(e))
        return False




@run_in_thread
def send_new_device_login_email(
    to_email: str,
    username: str,
    device_name: str,    # e.g., "Chrome on MacOS"
    location: str,       # e.g., "London, UK"
    ip_address: str,
    sender_email: str,
    sender_name: str,
    os_name:str,
    browser: str,
    user_agent : str
):
    """
    Sends a security alert when a login occurs from a new device/browser.
    """
    subject = f"Security alert: New login for {username}"
    from_email = f"{sender_name} <{sender_email}>"
    utc_login_time = datetime.now(timezone.utc).strftime('%B %d, %Y at %I:%M %p UTC')
    ist_timezone = timezone(timedelta(hours=5, minutes=30))
    ist_login_time = datetime.now(timezone.utc).astimezone(ist_timezone).strftime('%b %d, %Y at %I:%M %p IST')


    # Plain text version
    text_content = f"""
    New Login Alert
    Hello {username},
    We detected a new login to your account.
    Location: {location} (IP: {ip_address})
    UTC Time: {utc_login_time}
    IST Time: {ist_login_time}
    
    If this was you, you can ignore this email. 
    If you don't recognize this activity, please change your password immediately.
    """

    print(text_content)


    if not env_bool("ENABLE_SENDING_EMAILS"):
        return True
    
    
    # Professional HTML version
    html_content = get_device_login_template(
        name=username,
        os=os_name,
        browser=browser,
        location=location,
        ip_address=ip_address,
        utc_time=utc_login_time,
        ist_time=ist_login_time,
        user_agent=user_agent
    )   
    
    
    try:
        email = EmailMultiAlternatives(
            subject=subject,
            body=text_content,
            from_email=from_email,
            to=[to_email],
        )
        email.attach_alternative(html_content, "text/html")
        email.send()
        return True
    except Exception as e:
        print(f"Device login email failed: {e}")
        return False
    
