def get_otp_email_template(name, otp):
    """
    Returns a mobile-optimized, dark-themed Indzs OTP email template.
    Uses media queries to handle small screens and prevents font overflow.
    """
    return f"""
    <!DOCTYPE html>
    <html>
    <head>
      <meta charset="utf-8">
      <meta name="viewport" content="width=device-width, initial-scale=1.0">
      <style>
        body {{
          font-family: 'Inter', -apple-system, Arial, sans-serif;
          background-color: #09090b;
          margin: 0;
          padding: 0;
          -webkit-text-size-adjust: 100%;
        }}
        .container {{
          max-width: 600px;
          margin: 0 auto;
          padding: 20px 12px;
        }}
        .card {{
          background-color: #09090b;
          border: 1px solid #27272a;
          border-radius: 24px;
          padding: 32px 20px;
        }}
        .logo-text {{
          font-size: 24px;
          font-weight: 800;
          letter-spacing: -0.05em;
          margin-bottom: 24px;
        }}
        .c-blue   {{ color: #4285F4; }}
        .c-red    {{ color: #EA4335; }}
        .c-yellow {{ color: #FBBC05; }}
        .c-green  {{ color: #34A853; }}
        .accent-line {{
          width: 32px;
          height: 4px;
          background-color: #df7016;
          border-radius: 10px;
          margin-bottom: 20px;
        }}
        h1 {{
          color: #fafafa;
          font-size: 22px;
          font-weight: 700;
          margin: 0 0 8px 0;
          letter-spacing: -0.02em;
        }}
        .greeting {{
          color: #df7016;
          font-weight: 600;
        }}
        p {{
          color: #a1a1aa;
          font-size: 14px;
          line-height: 1.5;
          margin-bottom: 20px;
        }}
        .otp-wrapper {{
          background-color: #18181b;
          border: 1px solid #27272a;
          border-radius: 20px;
          padding: 30px 10px;
          text-align: center;
          margin: 24px 0;
        }}
        .otp-label {{
          font-size: 10px;
          font-weight: 700;
          text-transform: uppercase;
          letter-spacing: 0.1em;
          color: #df7016;
          margin-bottom: 12px;
        }}
        .otp-code {{
          font-family: ui-monospace, monospace;
          font-size: 32px;
          font-weight: 800;
          color: #fafafa;
          letter-spacing: 4px;
          margin: 0;
        }}
        .security-note {{
          font-size: 12px;
          color: #52525b;
          border-top: 1px solid #27272a;
          margin-top: 32px;
          padding-top: 20px;
        }}
        .footer {{
          text-align: center;
          margin-top: 24px;
          font-size: 11px;
          color: #3f3f46;
        }}
        
        /* Desktop Overrides */
        @media only screen and (min-width: 480px) {{
          .container {{ padding: 40px 20px; }}
          .card {{ padding: 48px; }}
          .logo-text {{ font-size: 28px; }}
          h1 {{ font-size: 26px; }}
          p {{ font-size: 15px; }}
          .otp-code {{ font-size: 52px; letter-spacing: 12px; }}
          .otp-wrapper {{ padding: 40px 20px; }}
        }}
      </style>
    </head>
    <body>
      <div class="container">
        <div class="card">
          <div class="logo-text">
            <span class="c-blue">I</span><span class="c-red">n</span><span class="c-yellow">d</span><span class="c-green">z</span><span class="c-blue">s</span>
          </div>
          <div class="accent-line"></div>
          <h1>Hi, <span class="greeting">{name}</span>!</h1>
          <p>
            Please use the code below to complete your secure sign-in to the <strong>Indzs Admin Portal</strong>.
          </p>
          <div class="otp-wrapper">
            <div class="otp-label">Security Access Code</div>
            <div class="otp-code">{otp}</div>
          </div>
          <div class="security-note">
            If you did not attempt to sign in, please ignore this email or contact your administrator.
          </div>
        </div>
        <div class="footer">
          &copy; 2026 Indzs Ecosystem &bull; Secure Systems
        </div>
      </div>
    </body>
    </html>
    """



def get_device_login_template(name, os, browser, location, ip_address, utc_time,ist_time, user_agent):
    """
    Returns a professional, dark-themed Indzs device login alert template.
    """
    return f"""
    <!DOCTYPE html>
    <html lang="en">
    <head>
      <meta charset="UTF-8">
      <meta name="viewport" content="width=device-width, initial-scale=1.0">
      <style>
        /* Base Styles */
        body {{
          font-family: 'Inter', -apple-system, system-ui, sans-serif;
          background-color: #09090b;
          margin: 0; padding: 0;
          color: #fafafa;
        }}
        .container {{ max-width: 600px; margin: 0 auto; padding: 40px 12px; }}
        
        /* Card UI */
        .card {{
          background-color: #09090b;
          border: 1px solid #27272a;
          border-radius: 24px;
          padding: 48px 32px;
        }}
        
        /* Logo & Header */
        .logo-text {{ font-size: 28px; font-weight: 800; letter-spacing: -0.05em; margin-bottom: 24px; }}
        .c-blue {{ color: #4285F4; }} .c-red {{ color: #EA4335; }} 
        .c-yellow {{ color: #FBBC05; }} .c-green {{ color: #34A853; }}
        
        .accent-line {{
          width: 40px; height: 4px;
          background-color: #EA4335; /* Alert Red */
          border-radius: 10px; margin-bottom: 24px;
        }}
        
        h1 {{ font-size: 24px; font-weight: 700; margin: 0 0 12px 0; color: #ffffff; }}
        .highlight {{ color: #df7016; }}
        p {{ color: #a1a1aa; font-size: 15px; line-height: 1.6; margin-bottom: 24px; }}

        /* Info Grid */
        .info-box {{
          background-color: #18181b;
          border: 1px solid #27272a;
          border-radius: 20px;
          padding: 24px;
          margin: 24px 0;
        }}
        .info-item {{
          padding: 12px 0;
          border-bottom: 1px solid #27272a;
        }}
        .info-item:last-child {{ border-bottom: none; }}
        .label {{
          font-size: 11px;
          font-weight: 700;
          text-transform: uppercase;
          color: #df7016;
          letter-spacing: 0.05em;
          margin-bottom: 4px;
        }}
        .value {{ font-size: 14px; color: #fafafa; font-weight: 500; }}
        .ua-text {{ font-size: 12px; color: #71717a; font-family: monospace; word-break: break-all; }}

        /* Alert Box */
        .warning-footer {{
          background-color: #450a0a;
          border: 1px solid #7f1d1d;
          border-radius: 16px;
          padding: 20px;
          margin-top: 32px;
        }}
        
        @media (max-width: 480px) {{
          .card {{ padding: 32px 20px; }}
          h1 {{ font-size: 20px; }}
        }}
      </style>
    </head>
    <body>
      <div class="container">
        <div class="card">
          <div class="logo-text">
            <span class="c-blue">I</span><span class="c-red">n</span><span class="c-yellow">d</span><span class="c-green">z</span><span class="c-blue">s</span>
          </div>
          <div class="accent-line"></div>
          
          <h1>Security Alert: <span class="highlight">New Device Login</span></h1>
          <p>Hi {name}, we detected a successful login to your Indzs account from a device or location you don't usually use.</p>
          
          <div class="info-box">
            <div class="info-item">
              <div class="label">Operating System</div>
              <div class="value">{os}</div>
            </div>
            <div class="info-item">
              <div class="label">Browser / Client</div>
              <div class="value">{browser}</div>
            </div>
            <div class="info-item">
              <div class="label">Location</div>
              <div class="value">{location}</div>
            </div>
            <div class="info-item">
              <div class="label">IP Address</div>
              <div class="value">{ip_address}</div>
            </div>
            <div class="info-item">
              <div class="label">Time (UTC)</div>
              <div class="value">{utc_time}</div>
            </div>
            <div class="info-item">
              <div class="label">Time (IST)</div>
              <div class="value">{ist_time}</div>
            </div>
            <div class="info-item">
              <div class="label">Full User Agent</div>
              <div class="ua-text">{user_agent}</div>
            </div>
          </div>

          <div class="warning-footer">
            <p style="color: #fecaca; margin: 0; font-size: 14px;">
              <strong>Not you?</strong> If this wasn't you, your account password may be compromised. Please <strong>change your password</strong> immediately to secure your data.
            </p>
          </div>
        </div>
        <p style="text-align: center; color: #3f3f46; font-size: 11px; margin-top: 24px;">
          &copy; 2026 Indzs Ecosystem • Automated Security Notification
        </p>
      </div>
    </body>
    </html>
    """
    
# def get_new_device_login_template(name, device_name, location, ip_address, time):
#     """
#     Returns a mobile-optimized, dark-themed Indzs New Device Login alert template.
#     """
#     return f"""
#     <!DOCTYPE html>
#     <html>
#     <head>
#       <meta charset="utf-8">
#       <meta name="viewport" content="width=device-width, initial-scale=1.0">
#       <style>
#         body {{
#           font-family: 'Inter', -apple-system, Arial, sans-serif;
#           background-color: #09090b;
#           margin: 0;
#           padding: 0;
#           -webkit-text-size-adjust: 100%;
#         }}
#         .container {{
#           max-width: 600px;
#           margin: 0 auto;
#           padding: 20px 12px;
#         }}
#         .card {{
#           background-color: #09090b;
#           border: 1px solid #27272a;
#           border-radius: 24px;
#           padding: 32px 20px;
#         }}
#         .logo-text {{
#           font-size: 24px;
#           font-weight: 800;
#           letter-spacing: -0.05em;
#           margin-bottom: 24px;
#         }}
#         .c-blue   {{ color: #4285F4; }}
#         .c-red    {{ color: #EA4335; }}
#         .c-yellow {{ color: #FBBC05; }}
#         .c-green  {{ color: #34A853; }}
#         .accent-line {{
#           width: 32px;
#           height: 4px;
#           background-color: #EA4335; /* Red for security alert */
#           border-radius: 10px;
#           margin-bottom: 20px;
#         }}
#         h1 {{
#           color: #fafafa;
#           font-size: 22px;
#           font-weight: 700;
#           margin: 0 0 8px 0;
#           letter-spacing: -0.02em;
#         }}
#         .greeting {{
#           color: #df7016;
#           font-weight: 600;
#         }}
#         p {{
#           color: #a1a1aa;
#           font-size: 14px;
#           line-height: 1.5;
#           margin-bottom: 20px;
#         }}
#         .info-wrapper {{
#           background-color: #18181b;
#           border: 1px solid #27272a;
#           border-radius: 20px;
#           padding: 24px;
#           margin: 24px 0;
#         }}
#         .info-row {{
#           margin-bottom: 12px;
#           border-bottom: 1px solid #27272a;
#           padding-bottom: 12px;
#         }}
#         .info-row:last-child {{
#           margin-bottom: 0;
#           border-bottom: none;
#           padding-bottom: 0;
#         }}
#         .label {{
#           font-size: 10px;
#           font-weight: 700;
#           text-transform: uppercase;
#           letter-spacing: 0.1em;
#           color: #df7016;
#           margin-bottom: 4px;
#         }}
#         .value {{
#           font-size: 15px;
#           color: #fafafa;
#           font-weight: 500;
#         }}
#         .warning-box {{
#           background-color: #450a0a;
#           border: 1px solid #7f1d1d;
#           border-radius: 12px;
#           padding: 16px;
#           margin-top: 24px;
#         }}
#         .warning-text {{
#           color: #fecaca;
#           font-size: 13px;
#           margin: 0;
#         }}
#         .footer {{
#           text-align: center;
#           margin-top: 24px;
#           font-size: 11px;
#           color: #3f3f46;
#         }}
        
#         @media only screen and (min-width: 480px) {{
#           .container {{ padding: 40px 20px; }}
#           .card {{ padding: 48px; }}
#           h1 {{ font-size: 26px; }}
#           .info-wrapper {{ padding: 32px; }}
#         }}
#       </style>
#     </head>
#     <body>
#       <div class="container">
#         <div class="card">
#           <div class="logo-text">
#             <span class="c-blue">I</span><span class="c-red">n</span><span class="c-yellow">d</span><span class="c-green">z</span><span class="c-blue">s</span>
#           </div>
#           <div class="accent-line"></div>
#           <h1>Security Alert: <span class="greeting">New Login</span></h1>
#           <p>
#             Hello {name}, your <strong>Indzs Admin Account</strong> was just accessed from a new device or browser.
#           </p>
          
#           <div class="info-wrapper">
#             <div class="info-row">
#               <div class="label">Device</div>
#               <div class="value">{device_name}</div>
#             </div>
#             <div class="info-row">
#               <div class="label">Location</div>
#               <div class="value">{location}</div>
#             </div>
#             <div class="info-row">
#               <div class="label">IP Address</div>
#               <div class="value">{ip_address}</div>
#             </div>
#             <div class="info-row">
#               <div class="label">Time</div>
#               <div class="value">{time}</div>
#             </div>
#           </div>

#           <div class="warning-box">
#             <p class="warning-text">
#               <strong>Wasn't you?</strong> If you don't recognize this activity, please change your password immediately and secure your account.
#             </p>
#           </div>
#         </div>
#         <div class="footer">
#           &copy; 2026 Indzs Ecosystem &bull; Security Systems Division
#         </div>
#       </div>
#     </body>
#     </html>
#     """