import random
import hashlib
import hmac

def generate_otp():
    return str(random.randint(100000, 999999))

def hash_otp(otp: str):
    return hashlib.sha256(otp.encode()).hexdigest()


def verify_otp_hash(plain_otp: str, stored_hash: str) -> bool:
    """
    Constant-time OTP hash comparison to prevent timing attacks
    """
    computed_hash = hashlib.sha256(plain_otp.encode()).hexdigest()
    return hmac.compare_digest(computed_hash, stored_hash)
