from PIL import Image
from io import BytesIO
from django.core.files.base import ContentFile

ALLOWED_EXTENSIONS = ("jpg", "jpeg", "png")
MAX_SIZE = (1024, 1024)

def process_profile_image(file):
    filename = file.name.lower()

    if not filename.endswith(ALLOWED_EXTENSIONS):
        raise ValueError("Only JPG and PNG images are allowed")

    try:
        image = Image.open(file)
        image.verify()  # 🔒 verify first
    except Exception:
        raise ValueError("Invalid image")

    file.seek(0)  # ⚠️ REQUIRED for Blob
    image = Image.open(file)

    if image.mode in ("RGBA", "P"):
        image = image.convert("RGB")

    image.thumbnail(MAX_SIZE, Image.Resampling.LANCZOS)

    buffer = BytesIO()
    image.save(buffer, format="JPEG", quality=85, optimize=True)

    return ContentFile(buffer.getvalue())


# from PIL import Image
# from io import BytesIO
# from django.core.files.base import ContentFile

# ALLOWED_EXTENSIONS = ["jpg", "jpeg", "png"]
# MAX_SIZE = (1024, 1024)


# def process_profile_image(uploaded_file):
#     ext = uploaded_file.name.split(".")[-1].lower()

#     if ext not in ALLOWED_EXTENSIONS:
#         raise ValueError("Only JPG and PNG images are allowed")

#     image = Image.open(uploaded_file)

#     # Convert RGBA → RGB (for PNG transparency)
#     if image.mode in ("RGBA", "P"):
#         image = image.convert("RGB")

#     # Resize (maintains aspect ratio)
#     image.thumbnail(MAX_SIZE, Image.Resampling.LANCZOS)

#     buffer = BytesIO()
#     image.save(buffer, format="JPEG", quality=85, optimize=True)

#     return ContentFile(buffer.getvalue())
