from bson import ObjectId
from datetime import datetime, timezone
from core.db.mongo import user_sessions_collection
from hashlib import sha256


def hash_refresh_token(token: str) -> str:
    return sha256(token.encode()).hexdigest()


def deactivate_session(user_id, refresh_token_hash):
    return user_sessions_collection.update_one(
        {
            "user_id": ObjectId(user_id),
            "refresh_token_hash": refresh_token_hash,
            "is_active": True
        },
        {
            "$set": {
                "is_active": False,
                "logged_out_at": datetime.now(timezone.utc)
            }
        }
    )


def deactivate_all_sessions(user_id):
    return user_sessions_collection.update_many(
        {
            "user_id": ObjectId(user_id),
            "is_active": True
        },
        {
            "$set": {
                "is_active": False,
                "active":False,
                "logged_out_at": datetime.now(timezone.utc)
            }
        }
    )


def deactivate_specific_device(user_id, device_id, session_id):
    return user_sessions_collection.update_one(
        {
            "user_id": ObjectId(user_id),
            "device_id": device_id,
            "session_id" : session_id,
            "is_active": True
        },
        {
            "$set": {
                "is_active": False,
                "logged_out_at": datetime.now(timezone.utc)
            }
        }
    )
