from core.utils.msg91_send_message import msg91_send_otp
from core.utils.helpers import env_bool
import os

def send_otp_sms(phone_number: str, otp: str,country_code, purpose: str = "Verification"):
    """
    Reusable helper to send OTP via SMS
    """

    message = f"Your OTP for {purpose} is {otp}. Do not share this OTP with anyone."
    print(f"""{country_code}{phone_number}""")
    print(message)
    msg91_variable = os.getenv("MSG91_VARIABLE_NAME")
    if not msg91_variable:
        print("Msg91 Variable name is missing")
        return False
    
    if not env_bool("ENABLE_SENDING_MESSAGES"):
        return True
    try:
        response =msg91_send_otp(
        mobile=f"""{country_code}{phone_number}""",
        variables={msg91_variable: otp}
        )
        print(response)
    except Exception as e:
        print(e)
    
    

    
