from datetime import datetime, timezone


def remaining_block_time(blocked_until):
    now = datetime.now(timezone.utc)
    delta = blocked_until - now

    if delta.total_seconds() <= 0:
        return None

    hours, remainder = divmod(int(delta.total_seconds()), 3600)
    minutes = remainder // 60

    if hours > 0:
        return f"{hours} hour(s) {minutes} minute(s)"
    return f"{minutes} minute(s)"
