import re

EMAIL_REGEX = r"^[^@\s]+@[^@\s]+\.[^@\s]+$"
PHONE_REGEX = r"^\+?[1-9]\d{7,14}$"  # E.164-ish

def is_valid_email(email):
    return bool(re.match(EMAIL_REGEX, email))


def is_valid_phone(phone):
    return bool(re.match(PHONE_REGEX, phone))
