from functools import wraps
from rest_framework.response import Response
from rest_framework import status
import jwt
import os
JWT_SECRET = os.getenv("JWT_SECRET_KEY")
JWT_ALGO = "HS256"


def get_access_token_from_request(request):
    # Priority: Cookie → Authorization header (optional fallback)
    token = request.COOKIES.get("access_token")

    if not token:
        auth = request.headers.get("Authorization")
        if auth and auth.startswith("Bearer "):
            token = auth.split(" ", 1)[1]

    return token


def jwt_optional(view_func):
    @wraps(view_func)
    def wrapper(request, *args, **kwargs):
        token = get_access_token_from_request(request)

        request.user_id = None
        request.session_id = None

        if not token:
            return view_func(request, *args, **kwargs)

        try:
            payload = jwt.decode(
                token,
                JWT_SECRET,
                algorithms=JWT_ALGO
            )

            request.user_id = payload.get("sub")
            request.session_id = payload.get("session_id")

        except jwt.ExpiredSignatureError:
            pass  # silent ignore

        except jwt.InvalidTokenError:
            pass  # silent ignore

        return view_func(request, *args, **kwargs)

    return wrapper
