"""
Django settings for config project.

Generated by 'django-admin startproject' using Django 5.2.10.

For more information on this file, see
https://docs.djangoproject.com/en/5.2/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/5.2/ref/settings/
"""

from pathlib import Path

import os

from dotenv import load_dotenv
load_dotenv()
from core.utils.helpers import env_bool

# Build paths inside the project like this: BASE_DIR / 'subdir'.
BASE_DIR = Path(__file__).resolve().parent.parent


# Quick-start development settings - unsuitable for production
# See https://docs.djangoproject.com/en/5.2/howto/deployment/checklist/

# SECURITY WARNING: keep the secret key used in production secret!
SECRET_KEY =  os.getenv("SECRET_KEY")


# SECURITY WARNING: don't run with debug turned on in production!
DEBUG = env_bool("DEBUG")

ALLOWED_HOSTS = os.getenv("ALLOWED_HOSTS", "").split(",")


# Application definition

INSTALLED_APPS = [
    'django.contrib.admin',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.messages',
    'django.contrib.staticfiles',
    
    # Third-party
    "rest_framework",
    "corsheaders",

    # Local apps
    "apps.auth.apps.AuthConfig",
    "apps.accounts.apps.AccountsConfig",
    # "apps.admin_accounts.apps.AdminAccountsConfig",
    "apps.support.apps.SupportConfig",
    # "apps.oauth.apps.OauthConfig",
    
]

MIDDLEWARE = [
    "corsheaders.middleware.CorsMiddleware",
    'django.middleware.security.SecurityMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.clickjacking.XFrameOptionsMiddleware',
]

ROOT_URLCONF = 'config.urls'

TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': [],
        'APP_DIRS': True,
        'OPTIONS': {
            'context_processors': [
                'django.template.context_processors.request',
                'django.contrib.auth.context_processors.auth',
                'django.contrib.messages.context_processors.messages',
            ],
        },
    },
]

WSGI_APPLICATION = 'config.wsgi.application'


# Database
# https://docs.djangoproject.com/en/5.2/ref/settings/#databases


DATABASES = {
    'default': {
        'ENGINE': 'django.db.backends.sqlite3',
        'NAME': BASE_DIR / 'db.sqlite3',
    },
    
     "app_chitraplay": {
        "ENGINE": "django.db.backends.mysql",
        "NAME": os.getenv("APP_CHITRAPLAY_DB_NAME"),
        "USER": os.getenv("APP_CHITRAPLAY_DB_USER"),
        "PASSWORD": os.getenv("APP_CHITRAPLAY_DB_PASSWORD"),
        "HOST": os.getenv("APP_CHITRAPLAY_DB_HOST"),
        "PORT": os.getenv("APP_CHITRAPLAY_DB_PORT"),
    }
}


# Password validation
# https://docs.djangoproject.com/en/5.2/ref/settings/#auth-password-validators

AUTH_PASSWORD_VALIDATORS = [
    {
        'NAME': 'django.contrib.auth.password_validation.UserAttributeSimilarityValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.MinimumLengthValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.CommonPasswordValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.NumericPasswordValidator',
    },
]


# REST_FRAMEWORK = {
#     "EXCEPTION_HANDLER": "core.utils.exceptions.custom_exception_handler"
# }


# Internationalization
# https://docs.djangoproject.com/en/5.2/topics/i18n/

LANGUAGE_CODE = 'en-us'

TIME_ZONE = 'UTC'

USE_I18N = True

USE_TZ = True


# -------- Static Files --------
# Static files (CSS, JavaScript, Images)
# https://docs.djangoproject.com/en/5.2/howto/static-files/

STATIC_URL = 'static/'

# Default primary key field type
# https://docs.djangoproject.com/en/5.2/ref/settings/#default-auto-field

DEFAULT_AUTO_FIELD = 'django.db.models.BigAutoField'


MEDIA_URL = "/media/"
# MEDIA_ROOT = BASE_DIR / "media"
MEDIA_ROOT = os.path.join(BASE_DIR, 'media')





from corsheaders.defaults import default_headers

CORS_ALLOW_HEADERS = list(default_headers) + [
    "x-device-info",
    "x-device-id",
]


# -------- CORS --------

CORS_ALLOW_CREDENTIALS = env_bool("CORS_ALLOW_CREDENTIALS")

CORS_ALLOWED_ORIGINS = os.getenv("CORS_ALLOWED_ORIGINS", "").split(",")


# 3. If you are using Django's built-in session/auth cookies:
CSRF_TRUSTED_ORIGINS = os.getenv("CSRF_TRUSTED_ORIGINS", "").split(",")


# -------- Security Settings --------
SECURE_SSL_REDIRECT = env_bool("SECURE_SSL_REDIRECT")

SESSION_COOKIE_SECURE = env_bool("SESSION_COOKIE_SECURE")

CSRF_COOKIE_SECURE = env_bool("CSRF_COOKIE_SECURE")

SECURE_HSTS_SECONDS = int(os.getenv("SECURE_HSTS_SECONDS", 0))

SECURE_HSTS_INCLUDE_SUBDOMAINS = env_bool("SECURE_HSTS_INCLUDE_SUBDOMAINS")


SECURE_HSTS_PRELOAD = env_bool("SECURE_HSTS_PRELOAD")




SESSION_COOKIE_SAMESITE = 'Lax'
CSRF_COOKIE_SAMESITE = 'Lax'








EMAIL_BACKEND = os.getenv("EMAIL_BACKEND")
EMAIL_HOST = os.getenv("EMAIL_HOST")
EMAIL_PORT = os.getenv("EMAIL_PORT")
EMAIL_USE_TLS = os.getenv("EMAIL_USE_TLS")

EMAIL_HOST_USER = os.getenv("EMAIL_HOST_USER")
EMAIL_HOST_PASSWORD = os.getenv("EMAIL_HOST_PASSWORD")
DEFAULT_FROM_EMAIL = os.getenv("DEFAULT_FROM_EMAIL")


GEOIP_CITY_DB_PATH = BASE_DIR / "geo/GeoLite2-City.mmdb"
GEOIP_ASN_DB_PATH = BASE_DIR / "geo/GeoLite2-ASN.mmdb"





SQL_APPS = {
     "app_chitraplay": {
        "ENGINE": "django.db.backends.mysql",
        "NAME": os.getenv("APP_CHITRAPLAY_DB_NAME"),
        "USER": os.getenv("APP_CHITRAPLAY_DB_USER"),
        "PASSWORD": os.getenv("APP_CHITRAPLAY_DB_PASSWORD"),
        "HOST": os.getenv("APP_CHITRAPLAY_DB_HOST"),
        "PORT": os.getenv("APP_CHITRAPLAY_DB_PORT"),
    }
}