from core.db.mongo import otp_collection, otp_ip_block_collection
from pymongo import ASCENDING


def create_indexes():
    # OTP expiry index (auto-delete expired OTPs)
    otp_collection.create_index(
        [("expires_at", ASCENDING)],
        expireAfterSeconds=0
    )

    # Prevent multiple OTPs per user in short time
    otp_collection.create_index(
        [("user_id", ASCENDING), ("created_at", ASCENDING)]
    )

    # IP block expiry index
    otp_ip_block_collection.create_index(
        [("blocked_until", ASCENDING)],
        expireAfterSeconds=0
    )

    # Ensure unique IP records
    otp_ip_block_collection.create_index(
        [("ip_address", ASCENDING)],
        unique=True
    )
