import os
from pymongo import MongoClient
from dotenv import load_dotenv

load_dotenv()

MONGO_URI = os.getenv("MONGO_URI", "mongodb://127.0.0.1:27017")
DB_NAME = os.getenv("MONGO_DB_NAME", "indzs_users")

client = MongoClient(MONGO_URI)
db = client[DB_NAME]

# Collections
users_collection = db["users"]

# 🔐 OTP collections
otp_collection = db.otp_requests
otp_ip_block_collection = db.otp_ip_blocks


recovery_verifications_collection = db.recovery_verifications


recovery_collection = db.recovery_accouts_collection

account_recovery_otp_collection = db.account_recovery_otp
account_recovery_rate_limit_collection = db.account_recovery_rate_limit_collection

login_attempts_collection = db.login_attempts_collection
user_sessions_collection = db["user_sessions"]
audit_logs = db.audit_logs

browser_sessions = db.browser_sessions
account_sessions = db.account_sessions


support_tickets_collection = db.support_tickets_collection

apps_col = db.installed_apps

oauth_clients = db.oauth_clients
auth_codes = db.auth_codes

def get_db():
    return db