# import pymysql
# from django.conf import settings

# def get_sql_connection(app):
#     config = settings.SQL_APPS[app]

#     return pymysql.connect(
#         host=config["HOST"],
#         port=config["PORT"],
#         user=config["USER"],
#         password=config["PASSWORD"],
#         database=config["NAME"],
#         cursorclass=pymysql.cursors.DictCursor,
#         autocommit=False
#     )


import os
import pymysql
from django.conf import settings

def get_app_a_connection():
    return pymysql.connect(
        host=os.getenv("APP_CHITRAPLAY_DB_HOST"),
        user=os.getenv("APP_CHITRAPLAY_DB_USER"),
        password=os.getenv("APP_CHITRAPLAY_DB_PASSWORD"),
        database=os.getenv("APP_CHITRAPLAY_DB_NAME"),
        port=int(os.getenv("APP_CHITRAPLAY_DB_PORT", 3306)),
        cursorclass=pymysql.cursors.DictCursor,
        autocommit=False
    )
    



def get_app_bhulok_connection():
    return pymysql.connect(
        host=os.getenv("APP_BHULOK_DB_HOST"),
        user=os.getenv("APP_BHULOK_DB_USER"),
        password=os.getenv("APP_BHULOK_DB_PASSWORD"),
        database=os.getenv("APP_BHULOK_DB_NAME"),
        port=int(os.getenv("APP_BHULOK_DB_PORT", 3306)),
        cursorclass=pymysql.cursors.DictCursor,
        autocommit=False
    )




def get_app_kujanam_connection():
    return pymysql.connect(
        host=os.getenv("APP_KUJANAM_DB_HOST"),
        user=os.getenv("APP_KUJANAM_DB_USER"),
        password=os.getenv("APP_KUJANAM_DB_PASSWORD"),
        database=os.getenv("APP_KUJANAM_DB_NAME"),
        port=int(os.getenv("APP_KUJANAM_DB_PORT", 3306)),
        cursorclass=pymysql.cursors.DictCursor,
        autocommit=False
    )
