from functools import wraps
import threading


def run_in_thread(fn):
    @wraps(fn)
    def wrapper(*args, **kwargs):
        thread = threading.Thread(target=fn, args=args, kwargs=kwargs)
        thread.start()
        return thread  # Handled in background
    return wrapper