import random
import string
from datetime import datetime
import os

def generate_ticket_number():
    date_part = datetime.utcnow().strftime("%Y%m%d")
    random_part = ''.join(random.choices(string.ascii_uppercase + string.digits, k=6))
    return f"TKT-{date_part}-{random_part}"


def get_client_ip(request):
    # Cloudflare 
    cf_ip = request.headers.get("CF-Connecting-IP")
    if cf_ip:
        return cf_ip.strip()

    # Standard proxy header
    xff = request.headers.get("X-Forwarded-For")
    if xff:
        return xff.split(",")[0].strip()

    # Fallback
    return request.META.get("REMOTE_ADDR")


def env_bool(key: str, default=False):
    return os.getenv(key, str(default)).lower() in ("1", "true", "yes", "on")