
import http.client
import json
import os
from typing import Dict, Any


MSG91_AUTH_KEY = os.getenv("MSG91_AUTH_KEY")
DLT_TEMPLATE_ID = os.getenv("MSG91_DLT_TEMPLATE_ID")
MSG91_DLT_SENDER = os.getenv("MSG91_DLT_SENDER")





class MSG91Error(Exception):
    pass


def msg91_send_otp(
    mobile: str,
    variables: Dict[str, Any],
    *,
    template_id: str = DLT_TEMPLATE_ID,
    sender_id: str = MSG91_DLT_SENDER,
    auth_key: str = MSG91_AUTH_KEY,
    timeout: int = 100,
) -> Dict[str, Any]:
    """
    Send SMS using MSG91 Flow API via http.client
    """

    if not all([template_id, sender_id, auth_key]):
        raise MSG91Error("MSG91 credentials are missing")

    payload = {
        "template_id": template_id,
        "sender": sender_id,
        "mobiles": mobile,
        **variables,  # inject flow variables
    }

    body = json.dumps(payload)

    headers = {
        "Content-Type": "application/json",
        "authkey": auth_key,
        "Content-Length": str(len(body)),
    }

    conn = http.client.HTTPSConnection("control.msg91.com", timeout=timeout)

    try:
        conn.request(
            method="POST",
            url="/api/v5/flow/",
            body=body,
            headers=headers,
        )

        response = conn.getresponse()
        response_body = response.read().decode()

        try:
            data = json.loads(response_body)
        except json.JSONDecodeError:
            raise MSG91Error(f"Invalid response from MSG91: {response_body}")

        if response.status != 200 or data.get("type") == "error":
            raise MSG91Error(f"MSG91 SMS failed: {data}")

        return data

    finally:
        conn.close()




